<?php


class HashtagVideo extends AppModel
{

    public $useTable = 'hashtag_video';

    public $belongsTo = array(
        'Hashtag' => array(
            'className' => 'Hashtag',
            'foreignKey' => 'hashtag_id',



        ),'Video' => array(
            'className' => 'Video',
            'foreignKey' => 'video_id',



        ),

    );



    public function getDetails($id)
    {
        return $this->find('first', array(
            'conditions' => array(



                'HashtagVideo.id'=> $id,




            )
        ));
    }
    public $custom_fields = array(
        "Video.id",
        "Video.user_id",
        "Video.description",
        "Video.video",
        "Video.thum",
        "Video.thum_small",
        "Video.gif",
        "Video.view",
        "Video.sound_id",
        "Video.privacy_type",
        "Video.allow_comments",
        "Video.allow_duet",
        "Video.duration",
        "Video.promote",
        "Video.pin_comment_id",
        "Video.pin",
        "Video.location_string",
        "Video.location_id",
        "Video.lat",
        "Video.long",
        "Video.width",
        "Video.height",

        "Video.user_thumbnail",
        "Video.default_thumbnail",

        "HashtagVideo.*",
        "Hashtag.*",

    );
    public function getHashtagVideos($hashtag_id)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('all', array(
            'contain' => array('Video.Sound','Video.User.PrivacySetting','Video.User.PushNotification','Video.Location','Hashtag'),
            'conditions' => array(



                'HashtagVideo.hashtag_id'=> $hashtag_id,
                'Video.privacy_type'=> "public",
                'Video.user_id >'=> 0,



            ),
            'order' => 'Video.view DESC',
        ));
    }

    public function getHashtagVideosLimit($hashtag_id)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('all', array(
            'contain' => array('Video','Hashtag'),


            'conditions' => array(



                'HashtagVideo.hashtag_id'=> $hashtag_id,
                'Video.privacy_type'=> "public",
                'Video.user_id >'=> 0,




            ),
            'limit'=>5,
            'order' => 'Video.view DESC',
        ));
    }


    public function getHashtagVideosWithLimit($hashtag_id,$starting_point)
    {
        $this->Behaviors->attach('Containable');

        return $this->find('all', array(
            'contain' => array('Hashtag','Video'),
            'conditions' => array(



                'HashtagVideo.hashtag_id'=> $hashtag_id,
                'Video.privacy_type'=> "public",




            ),
           // 'contain' => array('Hashtag'),
            'fields' => $this->custom_fields,
            'limit' => APP_RECORDS_PER_PAGE,
            'offset' => $starting_point * APP_RECORDS_PER_PAGE,

            'order' => 'Video.view DESC',
        ));
    }
    public function getHashtagVideosWithLimittemp($hashtag_id,$starting_point)
    {
        $this->Behaviors->attach('Containable');

        return $this->find('all', array(
            'contain' => array('Hashtag','Video'),
            'conditions' => array(



                'HashtagVideo.hashtag_id'=> $hashtag_id,
                'Video.privacy_type'=> "public",
                 'Video.user_id >'=> 0,




            ),
             'fields' =>  array(
                 "Video.id",
                 "Video.user_id",
                 "Video.description",
                 "Video.video",
                 "Video.thum",
                 "Video.thum_small",
                 "Video.gif",
                 "Video.view",
                 "Video.sound_id",
                 "Video.privacy_type",
                 "Video.allow_comments",
                 "Video.allow_duet",
                 "Video.duration",
                 "Video.promote",
                 "Video.pin_comment_id",
                 "Video.pin",
                 "Video.location_string",
                 "Video.location_id",
                 "Video.lat",
                 "Video.long",
                 "Video.width",
                 "Video.height",

                 "Video.user_thumbnail",
                 "Video.default_thumbnail",
               
                 "HashtagVideo.*",


             ),
            //'fields' => $this->custom_fields,
            'limit' => APP_RECORDS_PER_PAGE,
            'offset' => $starting_point * APP_RECORDS_PER_PAGE,

            'order' => 'Video.view DESC',
        ));
    }

    public function countHashtagViews($hashtag_id)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('first', array(
            'contain' => array('Video.Sound','Video.User'),
            'conditions' => array(



                'HashtagVideo.hashtag_id'=> $hashtag_id,
                'Video.privacy_type'=> "public",




            ),
            'fields' => array( 'sum(Video.view) as total_sum'),
            'order' => 'Video.view DESC',
        ));
    }
    public function countHashtagVideos($hashtag_id)
    {

        return $this->find('count', array(
            //'contain' => array('Video'),
            'conditions' => array(



                'HashtagVideo.hashtag_id'=> $hashtag_id,
                'Video.privacy_type'=> "public",





            ),



        ));
    }
    public function getHastagsWhichHasGreaterNoOfVideos($starting_point)
    {
        $this->Behaviors->attach('Containable');
        return $this->find('all', array(

            'fields' => array( 'DISTINCT HashtagVideo.hashtag_id','Hashtag.*','sum(Video.view) as total_views'),

            'group' => array('HashtagVideo.hashtag_id'),
            //'order' => 'total_views DESC',
            'order' => 'COUNT(HashtagVideo.hashtag_id) DESC',
            'limit'=>5,
            'offset' => $starting_point*5,
            'conditions' => array(
                'Video.id IS NOT NULL'
            )



        ));
    }

    public function getHastagsWhichHasGreaterNoOfVideosAdmin()
    {
        $this->Behaviors->attach('Containable');
        return $this->find('all', array(

            'fields' => array( 'DISTINCT HashtagVideo.hashtag_id','Hashtag.*','sum(Video.view) as total_views'),

            'group' => array('HashtagVideo.hashtag_id'),
            'order' => 'total_views DESC',


        ));
    }

    public function ifExist($data)
    {
        return $this->find('first', array(
            'conditions' => array(



                'HashtagVideo.hashtag_id'=> $data['hashtag_id'],
                'HashtagVideo.video_id'=> $data['video_id'],




            )
        ));
    }




    public function deleteDataAgainstVideo($video_id){

        $this->deleteAll(
            [
                'HashtagVideo.video_id' => $video_id,

            ],
            false # <- single delete statement please
        );
    }


}
?>