<?php



class Card extends AppModel
{
    public $useTable = 'card';


    /*public $belongsTo = array(

        'User' => array(
            'className' => 'User',
            'foreignKey' => 'user_id',

        ),
    );*/

    public function getDetails($id)
    {

        return $this->find('first', array(
            'conditions' => array('Card.id' => $id)
        ));

    }

    public function isUserStripeCustIDExist($id)
    {

        return $this->find('first', array(
            'conditions' => array('Card.user_id' => $id)
        ));

    }

    public function ifAnyCardExistCardAgainstUser($user_id)
    {
        //$this->Behaviors->attach('Containable');
        return $this->find('count', array(
            'conditions' => array(
                'Card.user_id' => $user_id,

            ),
            //'contain'=>array('User')
        ));

    }

    public function getDefaultCard($user_id)
    {
        //$this->Behaviors->attach('Containable');
        return $this->find('count', array(
            'conditions' => array(
                'Card.user_id' => $user_id,
                'Card.default' => 1,

            ),
            //'contain'=>array('User')
        ));

    }

    public function getDefaultCardDetails($user_id)
    {
        //$this->Behaviors->attach('Containable');
        return $this->find('first', array(
            'conditions' => array(
                'Card.user_id' => $user_id,
                'Card.default' => 1,

            ),
            //'contain'=>array('User')
        ));

    }

    public function getCardDetailsAgainstCardID($card_id)
    {
        //$this->Behaviors->attach('Containable');
        return $this->find('first', array(
            'conditions' => array(

                'Card.card_id' => $card_id,

            ),
            //'contain'=>array('User')
        ));

    }

    public function getCardDetailsAgainstCardIDAndUserID($user_id,$card_id)
    {
        //$this->Behaviors->attach('Containable');
        return $this->find('first', array(
            'conditions' => array(

                'Card.id' => $card_id,
                'Card.user_id' => $user_id,

            ),
            //'contain'=>array('User')
        ));

    }

    public function ifExistCardAgainstUser($user_id,$id)
    {
        //$this->Behaviors->attach('Containable');
        return $this->find('first', array(
            'conditions' => array(
                'Card.user_id' => $user_id,
                'Card.id' => $id,
            ),
            //'contain'=>array('User')
        ));

    }

    public function setAllCardsUndefaultAgainstUser($user_id,$card_id){

        $this->updateAll(
            array('Card.default' => 0),
            array(
                'Card.user_id' => $user_id,
                'Card.card_id !=' => $card_id,

            )
        );

    }

    public function getUserCards($user_id)
    {
        return $this->find('all', array(
            'conditions' => array(

                'Card.user_id' => $user_id,




            ),
            'order'=>'Card.id ASC'
            //'fields'=>array('stripe','id'),
        ));


    }

}