<?php


class VideoTemp extends AppModel
{

    public $useTable = 'video_temp';

    public $belongsTo = array(
        'User' => array(
            'className' => 'User',
            'foreignKey' => 'user_id',



        ),'Video' => array(
            'className' => 'Video',
            'foreignKey' => 'video_id',



        ),



    );

    public function getDetails($id)
    {
        return $this->find('first', array(
            'conditions' => array(



                'VideoTemp.id'=> $id,




            ),
            'recursive'=>-1,
        ));
    }

    public function getDetailsAgainstIDAndUserID($user_id,$id)
    {
        return $this->find('first', array(
            'conditions' => array(



                'VideoTemp.id'=> $id,
                'VideoTemp.user_id'=> $user_id,





            )
        ));
    }

    public function getOldRecords()
    {
        return $this->find('all', array(
            'conditions' => array(
                'VideoTemp.created <' => date('Y-m-d H:i:s', strtotime('-10 minutes'))
            )
        ));
    }

    public function countWatchVideos($video_ids,$start_datetime,$end_datetime)
    {

        return $this->find('count', array(
            'conditions' => array(



                'VideoWatch.video_id IN'=> $video_ids,
                'DATE(VideoWatch.created) >='=> $start_datetime,
                'DATE(VideoWatch.created) <='=> $end_datetime,




            )
        ));
    }

    public function countWatchVideosByDate($video_ids,$start_datetime,$end_datetime)
    {

        return $this->find('all', array(
            'fields' => array(
                'DATE(VideoWatch.created) AS date',
                'COUNT(*) AS count'
            ),
            'conditions' => array(
                'DATE(VideoWatch.created) >='=> $start_datetime,
                'DATE(VideoWatch.created) <='=> $end_datetime,
                'VideoWatch.video_id IN'=> $video_ids,
            ),
            'group' => 'DATE(VideoWatch.created)',
            'order' => 'DATE(VideoWatch.created) ASC'
        ));
    }


    public function ifExist($data)
    {
        return $this->find('first', array(
            'conditions' => array(



                'VideoWatch.video_id'=> $data['video_id'],
                'VideoWatch.device_id'=> $data['device_id'],




            )
        ));
    }

    public function getAll()
    {
        return $this->find('all');
    }






}
?>